/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import java.io.Serializable;
import nintaco.CPU;
import nintaco.PPU;
import nintaco.PPU2C05;
import nintaco.apu.APU;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.DualAPU;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.mappers.nintendo.vs.MainVsDualSystem;
import nintaco.mappers.nintendo.vs.VsGame;

public class Machine
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Mapper mapper;
    private final CPU cpu;
    private final PPU ppu;
    private final APU apu;
    private final boolean vsDualSystem;

    public Machine(Mapper mapper, VsGame vsGame) {
        this.mapper = mapper;
        if (vsGame != null) {
            this.vsDualSystem = vsGame.isDualSystemGame();
            if (this.vsDualSystem) {
                this.cpu = new MainCPU(((MainVsDualSystem)mapper).getSubVsDualSystem());
                this.apu = new DualAPU((DualAPU)((MainCPU)this.cpu).getSubAPU());
            } else {
                this.cpu = new CPU();
                this.apu = new APU();
            }
            switch (vsGame.getPPU()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.ppu = new PPU2C05(vsGame.getPpuStatusID());
                    break;
                }
                default: {
                    this.ppu = new PPU();
                    break;
                }
            }
        } else {
            this.vsDualSystem = false;
            this.cpu = new CPU();
            this.ppu = new PPU();
            this.apu = new APU();
        }
        this.cpu.setMachine(this);
        this.ppu.setMachine(this);
        this.apu.setMachine(this);
        this.apu.getDMC().setCPU(this.cpu);
        this.apu.reset();
    }

    public Machine(Mapper mapper, Machine machine) {
        mapper.copyMemory(machine.getMapper());
        this.mapper = mapper;
        this.vsDualSystem = machine.isVsDualSystem();
        this.cpu = machine.getCPU();
        this.apu = machine.getAPU();
        this.ppu = machine.getPPU();
        this.cpu.setMachine(this);
        this.ppu.setMachine(this);
        this.apu.setMachine(this);
        this.apu.getDMC().setCPU(this.cpu);
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public PPU getPPU() {
        return this.ppu;
    }

    public APU getAPU() {
        return this.apu;
    }

    public boolean isVsDualSystem() {
        return this.vsDualSystem;
    }
}

