/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import nintaco.AppMode;
import nintaco.Breakpoint;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.MessageException;
import nintaco.PPU;
import nintaco.PauseStepType;
import nintaco.api.local.LocalAPI;
import nintaco.api.server.ProgramServer;
import nintaco.apu.APU;
import nintaco.apu.SystemAudioProcessor;
import nintaco.cartdb.Cart;
import nintaco.cartdb.CartDB;
import nintaco.cheats.CheatsDB;
import nintaco.cheats.GameCheats;
import nintaco.disassembler.TraceLogger;
import nintaco.files.CartFile;
import nintaco.files.FdsFile;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.files.IFile;
import nintaco.files.NesFile;
import nintaco.files.NsfFile;
import nintaco.files.UnifFile;
import nintaco.gui.FourButtonDialog;
import nintaco.gui.IntPoint;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.YesNoDialog;
import nintaco.gui.api.local.ProgramFrame;
import nintaco.gui.api.server.ProgramServerFrame;
import nintaco.gui.asmdasm.AsmDasmFrame;
import nintaco.gui.barcodebattler.BarcodeBattlerFrame;
import nintaco.gui.cheats.search.CheatSearchFrame;
import nintaco.gui.debugger.DebuggerFrame;
import nintaco.gui.dipswitches.DipSwitchesDialog;
import nintaco.gui.familybasic.BackgroundEditorFrame;
import nintaco.gui.fds.DiskActivityIndicator;
import nintaco.gui.glasses.GlassesFrame;
import nintaco.gui.hexeditor.HexEditorFrame;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryEditorFrame;
import nintaco.gui.historyeditor.HistoryProject;
import nintaco.gui.historyeditor.change.HistoryChange;
import nintaco.gui.historyeditor.change.InitializationChange;
import nintaco.gui.historyeditor.preferences.HistoryEditorPrefs;
import nintaco.gui.image.CursorType;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.ImagePaneFunction;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.image.SubMonitorFrameFunction;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.ips.PatchFrame;
import nintaco.gui.mapmaker.MapMakerFrame;
import nintaco.gui.nametables.NametablesFrame;
import nintaco.gui.netplay.client.NetplayClientFrame;
import nintaco.gui.netplay.server.NetplayServerFrame;
import nintaco.gui.oam.OamDataFrame;
import nintaco.gui.patterntables.PatternTablesFrame;
import nintaco.gui.ramsearch.RamSearchFrame;
import nintaco.gui.ramwatch.RamWatchFrame;
import nintaco.gui.rob.GyromiteController;
import nintaco.gui.rob.RobController;
import nintaco.gui.rob.RobFrame;
import nintaco.gui.rob.RobState;
import nintaco.gui.rob.StackUpController;
import nintaco.gui.sound.volumemixer.VolumeMixerFrame;
import nintaco.gui.spritesaver.SpriteSaverFrame;
import nintaco.gui.userinterface.UserInterfacePrefs;
import nintaco.gui.watchhistory.WatchHistoryFrame;
import nintaco.input.InputUtil;
import nintaco.input.dipswitches.DipSwitch;
import nintaco.input.other.ChangeDipSwitches;
import nintaco.input.other.Reset;
import nintaco.input.other.SetTVSystem;
import nintaco.input.other.SetupROB;
import nintaco.logger.LogUtil;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.fds.FdsMapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.mappers.nsf.NsfMapper;
import nintaco.movie.Movie;
import nintaco.netplay.client.NetplayClient;
import nintaco.netplay.server.NetplayServer;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.GuiUtil;
import nintaco.util.InstanceUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;
import nintaco.util.ThreadUtil;
import nintaco.util.TimeUtil;

public final class App {
    private static volatile AppMode appMode;
    private static SystemAudioProcessor systemAudioProcessor;
    private static MachineRunner machineRunner;
    private static Machine machine;
    private static PatchFrame applyIpsPatchFrame;
    private static AsmDasmFrame asmDasmFrame;
    private static BackgroundEditorFrame backgroundEditorFrame;
    private static BarcodeBattlerFrame barcodeBattlerFrame;
    private static CheatSearchFrame cheatSearchFrame;
    private static PatchFrame createIpsPatchFrame;
    private static DebuggerFrame debuggerFrame;
    private static GlassesFrame glassesFrame;
    private static HexEditorFrame hexEditorFrame;
    private static HistoryEditorFrame historyEditorFrame;
    private static ImageFrame imageFrame;
    private static MapMakerFrame mapMakerFrame;
    private static NametablesFrame nametablesFrame;
    private static NetplayClientFrame netplayClientFrame;
    private static NetplayServerFrame netplayServerFrame;
    private static OamDataFrame oamDataFrame;
    private static PatternTablesFrame patternTablesFrame;
    private static ProgramFrame programFrame;
    private static ProgramServerFrame programServerFrame;
    private static RamSearchFrame ramSearchFrame;
    private static RamWatchFrame ramWatchFrame;
    private static RobFrame robFrame;
    private static SpriteSaverFrame spriteSaverFrame;
    private static VolumeMixerFrame volumeMixerFrame;
    private static SubMonitorFrame subMonitorFrame;
    private static WatchHistoryFrame watchHistoryFrame;
    private static NesFile nesFile;
    private static FdsFile fdsFile;
    private static UnifFile unifFile;
    private static NsfFile nsfFile;
    private static String entryFileName;
    private static String license;
    private static int[] fdsBIOS;
    private static volatile int rewindTimeValue;
    private static volatile int highSpeedValue;
    private static final ProgramServer programServer;
    private static final NetplayServer netplayServer;
    private static final NetplayClient netplayClient;
    private static volatile TraceLogger traceLogger;
    private static volatile LocalAPI localAPI;
    private static boolean fds;
    private static boolean diskActivity;
    private static DiskActivityIndicator diskActivityIndicator;
    private static volatile boolean diskActivityIndicatorChanged;
    private static String historyProjectName;
    private static boolean lastPlayFrameHasFocus;
    private static boolean lastApplicationHasFocus;
    private static boolean pausedOnFocusLoss;

    public static void init(String ... args) throws Throwable {
        ThreadUtil.forceHighResolutionTime();
        LogUtil.init(args);
        AppPrefs.load();
        if (!AppPrefs.getInstance().getUserInterfacePrefs().isAllowMultipleInstances() && InstanceUtil.isAlreadyRunning()) {
            return;
        }
        systemAudioProcessor = new SystemAudioProcessor();
        App.loadLicense();
        CartDB.init();
        CheatsDB.init();
        PaletteUtil.init();
        EventQueue.invokeAndWait(() -> {
            App.initApplicationFocusListener();
            imageFrame = new ImageFrame();
            imageFrame.init();
            imageFrame.getImagePane().setTVSystem(TVSystem.NTSC);
            GuiUtil.requestVsync(imageFrame, true);
        });
        InputUtil.init();
        PPU.init();
        APU.init();
        AppPrefs.getInstance().getInputs().apply();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) continue;
            StringBuilder sb = new StringBuilder(arg);
            ++i;
            while (i < args.length) {
                sb.append(' ').append(args[i]);
                ++i;
            }
            imageFrame.openFile(sb.toString());
            break;
        }
    }

    public static void setAppMode(AppMode appMode) {
        App.appMode = appMode;
        InputUtil.handleSettingsChange();
        imageFrame.appModeChanged(appMode);
    }

    public static AppMode getAppMode() {
        return appMode;
    }

    public static boolean isRobGame() {
        return App.isGyromite() || App.isStackUp();
    }

    public static boolean isGyromite() {
        CartFile cartFile = App.getCartFile();
        return cartFile != null && (cartFile.getFileCRC() == 37378610 || cartFile.getFileCRC() == -2064699399);
    }

    public static boolean isStackUp() {
        CartFile cartFile = App.getCartFile();
        return cartFile != null && (cartFile.getFileCRC() == -546841951 || cartFile.getFileCRC() == -1750011632);
    }

    private static void initApplicationFocusListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", e -> EventQueue.invokeLater(App::applicationFocusChanged));
    }

    private static void applicationFocusChanged() {
        boolean playFrameHasFocus;
        boolean applicationHasFocus;
        AppPrefs appPrefs = AppPrefs.getInstance();
        UserInterfacePrefs uiPrefs = appPrefs.getUserInterfacePrefs();
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        boolean bl = applicationHasFocus = activeWindow != null;
        if (lastApplicationHasFocus != applicationHasFocus) {
            boolean pause;
            lastApplicationHasFocus = applicationHasFocus;
            boolean bl2 = pause = !applicationHasFocus;
            if (applicationHasFocus && pausedOnFocusLoss || !uiPrefs.isRunInBackground() && (imageFrame.isDisplayingImagePane() || !appPrefs.getNsfPrefs().isPlayInBackground()) && (!programServer.isRunning() || !appPrefs.getProgramServerPrefs().isRunInBackground())) {
                pausedOnFocusLoss = pause;
                App.setNoStepPause(pause);
                if (applicationHasFocus) {
                    InputUtil.clearEventQueues();
                }
            }
        }
        boolean bl3 = playFrameHasFocus = activeWindow == imageFrame || glassesFrame != null && activeWindow == glassesFrame || robFrame != null && activeWindow == robFrame || subMonitorFrame != null && activeWindow == subMonitorFrame;
        if (lastPlayFrameHasFocus != playFrameHasFocus) {
            lastPlayFrameHasFocus = playFrameHasFocus;
            if (playFrameHasFocus) {
                InputUtil.setInputDisabled(false);
            } else if (!uiPrefs.isAcceptBackgroundInput()) {
                InputUtil.setInputDisabled(true);
            }
        }
    }

    private static void loadLicense() {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(App.class.getResourceAsStream("/nintaco/lgpl-2.1.txt")));){
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        license = sb.toString();
    }

    private static void addFrame(List<JFrame> frames, JFrame frame) {
        if (frame != null) {
            frames.add(frame);
        }
    }

    private static Machine getRunningMachine() {
        Machine m = machine;
        MachineRunner r = machineRunner;
        return m != null && r != null && r.isRunning() ? m : null;
    }

    public static void cpuKilled(int opcode, int address) {
        if (EventQueue.isDispatchThread()) {
            FourButtonDialog dialog = new FourButtonDialog((Window)imageFrame, String.format("<html>The processor executed a KIL (<tt>$%02X</tt>) instruction at <tt>$%04X</tt>.</html>", opcode, address), "CPU Killed", FourButtonDialog.IconType.ERROR);
            dialog.setButtonText(0, "Power Cycle", 80);
            dialog.setButtonText(1, "Reset", 82);
            dialog.setButtonText(2, "Close", 67);
            dialog.setButtonText(3, "Ignore", 73);
            dialog.setVisible(true);
            switch (dialog.getSelection()) {
                case 0: {
                    App.powerCycle();
                    break;
                }
                case 1: {
                    App.reset();
                    break;
                }
                case 2: {
                    App.close();
                }
            }
        } else {
            EventQueue.invokeLater(() -> App.cpuKilled(opcode, address));
        }
    }

    public static void importHistory() {
        HistoryEditorFrame frame;
        WatchHistoryFrame watchHistory = watchHistoryFrame;
        if (watchHistory != null) {
            watchHistory.getWatchHistoryPanel().pause();
        }
        if ((frame = historyEditorFrame) != null) {
            frame.load();
        } else {
            App.setNoStepPause(true);
            Paths paths = AppPrefs.getInstance().getPaths();
            String historiesDir = paths.getHistoriesDir();
            FileUtil.mkdir(historiesDir);
            JFileChooser chooser = GuiUtil.createFileChooser("Load History File", (File)null, HistoryEditorFrame.historyFileExtensionFilter);
            if (StringUtil.isBlank(historyProjectName)) {
                chooser.setCurrentDirectory(new File(paths.getHistoriesDir()));
            } else {
                chooser.setSelectedFile(FileUtil.getFile(paths.getHistoriesDir(), historyProjectName));
            }
            if (GuiUtil.showOpenDialog(imageFrame, chooser, (p, d) -> p.setHistoriesDir((String)d)) == 0) {
                File selectedFile = chooser.getSelectedFile();
                PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)imageFrame);
                pleaseWaitDialog.setMessage("Loading history file...");
                new Thread(() -> App.loadHistoryProjectFile(pleaseWaitDialog, selectedFile, entryFileName)).start();
                pleaseWaitDialog.showAfterDelay();
            } else {
                App.setNoStepPause(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadHistoryProjectFile(PleaseWaitDialog pleaseWaitDialog, File file, String entryFileName) {
        HistoryProject p;
        boolean showError;
        boolean failed = false;
        HistoryProject project = null;
        try {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
                project = (HistoryProject)in.readObject();
            }
            showError = failed;
            p = project;
            pleaseWaitDialog.dispose();
        }
        catch (Throwable t) {
            try {
                failed = true;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                boolean showError2 = failed;
                HistoryProject p2 = project;
                pleaseWaitDialog.dispose();
                EventQueue.invokeLater(() -> {
                    historyProjectName = file.getName();
                    if (showError2) {
                        GuiUtil.displayError(imageFrame, "Failed to load history file.");
                        App.setNoStepPause(false);
                    } else {
                        App.restoreHistoryProject(p2, entryFileName, file);
                    }
                });
            }
        }
        EventQueue.invokeLater(() -> {
            historyProjectName = file.getName();
            if (showError2) {
                GuiUtil.displayError(imageFrame, "Failed to load history file.");
                App.setNoStepPause(false);
            } else {
                App.restoreHistoryProject(p2, entryFileName, file);
            }
        });
    }

    private static void restoreHistoryProject(HistoryProject project, String entryFileName, File file) {
        CartFile cartFile = App.getCartFile();
        if (cartFile != null && cartFile.getFileCRC() != project.getEntryFileCRC() || cartFile == null && project.getEntryFileCRC() != 0 || !entryFileName.equalsIgnoreCase(project.getEntryFileName())) {
            YesNoDialog dialog = new YesNoDialog((Window)imageFrame, String.format("History game file: <pre>%s</pre><br/>Current game file: <pre>%s</pre><br/>Load history anyway?", project.getEntryFileName(), entryFileName), "Game File Mismatch");
            dialog.setVisible(true);
            if (!dialog.isYes()) {
                App.setNoStepPause(false);
                return;
            }
        }
        AppPrefs.getInstance().getPaths().addRecentHistoryProject(file.getPath());
        AppPrefs.save();
        imageFrame.movieLoaded(project.getMovie());
        App.setNoStepPause(false);
    }

    public static void exportHistory(Movie movie) {
        if (movie == null) {
            return;
        }
        HistoryEditorFrame frame = historyEditorFrame;
        if (frame != null) {
            frame.saveAs();
        } else {
            App.setNoStepPause(true);
            Paths paths = AppPrefs.getInstance().getPaths();
            String historiesDir = paths.getHistoriesDir();
            FileUtil.mkdir(historiesDir);
            File file = GuiUtil.showSaveAsDialog(imageFrame, historiesDir, historyProjectName, "history", HistoryEditorFrame.historyFileExtensionFilter, true, "Save History File");
            if (file != null) {
                historyProjectName = file.getName();
                String dir = file.getParent();
                paths.addRecentDirectory(dir);
                paths.setHistoriesDir(dir);
                AppPrefs.save();
                HistoryEditorPrefs prefs = new HistoryEditorPrefs();
                prefs.setFastGeneration(true);
                prefs.setMerge(false);
                prefs.setRestorePosition(true);
                prefs.setTrackCursor(true);
                prefs.setRecordPlayers(new boolean[4]);
                prefs.setViewPlayers(new boolean[]{true, true, false, false});
                HistoryProject project = new HistoryProject();
                CartFile cartFile = App.getCartFile();
                project.setEntryFileCRC(cartFile != null ? cartFile.getFileCRC() : 0);
                project.setEntryFileName(App.getEntryFileName());
                project.setBookmarks(new ArrayList<HistoryBookmark>());
                ArrayList<HistoryChange> historyChanges = new ArrayList<HistoryChange>();
                historyChanges.add(new InitializationChange());
                project.setChanges(historyChanges);
                project.setChangesIndex(1);
                project.setHistoryEditorPrefs(prefs);
                project.setLastClickedRowIndex(movie.frameIndex);
                project.setMovie(movie);
                project.setHeadIndex(movie.frameIndex);
                project.setLastIndex(-1);
                project.setTailIndex(movie.frameIndex);
                project.setHistoryScrollValues(new IntPoint());
                project.setBookmarksScrollValues(new IntPoint());
                project.setChangesScrollValues(new IntPoint());
                PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)imageFrame);
                pleaseWaitDialog.setMessage("Saving history file...");
                new Thread(() -> App.saveHistoryProjectFile(pleaseWaitDialog, file, project)).start();
                pleaseWaitDialog.showAfterDelay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveHistoryProjectFile(PleaseWaitDialog pleaseWaitDialog, File file, HistoryProject project) {
        boolean failed = false;
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            out.writeObject(project);
        }
        catch (Throwable t) {
            failed = true;
        }
        finally {
            boolean showError = failed;
            pleaseWaitDialog.dispose();
            EventQueue.invokeLater(() -> {
                if (showError) {
                    GuiUtil.displayError(imageFrame, "Failed to save history file.");
                } else {
                    AppPrefs.getInstance().getPaths().addRecentHistoryProject(file.getPath());
                    AppPrefs.save();
                }
                App.setNoStepPause(false);
            });
        }
    }

    public static int getFileIndex(int address, boolean cpuMemory) {
        Machine m = machine;
        if (m == null || address < 0) {
            return -1;
        }
        NesFile file = nesFile;
        if (file == null) {
            return -1;
        }
        Mapper mapper = m.getMapper();
        if (mapper == null) {
            return -1;
        }
        int index = file.getHeaderSize() + file.getTrainerSize();
        if (cpuMemory) {
            int offset = mapper.getPrgRomIndex(address);
            if (offset < 0) {
                return -1;
            }
            index += offset;
        } else {
            int offset = mapper.getChrRomIndex(address);
            if (offset < 0) {
                return -1;
            }
            index += file.getPrgRomSize() + offset;
        }
        return index;
    }

    private static void setDiskActivity(boolean activity, DiskActivityIndicator indicator) {
        int keyCode = 0;
        switch (indicator) {
            case NUM_LOCK: {
                keyCode = 144;
                break;
            }
            case CAPS_LOCK: {
                keyCode = 20;
                break;
            }
            case SCROLL_LOCK: {
                keyCode = 145;
                break;
            }
            case KANA_LOCK: {
                keyCode = 262;
                break;
            }
            default: {
                return;
            }
        }
        try {
            Toolkit.getDefaultToolkit().setLockingKeyState(keyCode, activity);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setDiskActivity(boolean diskActivity) {
        if (fds) {
            if (diskActivityIndicatorChanged) {
                diskActivityIndicatorChanged = false;
                App.diskActivity = false;
                App.setDiskActivity(App.diskActivity, diskActivityIndicator);
                diskActivityIndicator = AppPrefs.getInstance().getFamicomDiskSystemPrefs().getDiskActivityIndicator();
            }
            if (diskActivity) {
                if (!App.diskActivity) {
                    App.diskActivity = true;
                    App.setDiskActivity(App.diskActivity, diskActivityIndicator);
                }
            } else if (App.diskActivity) {
                App.diskActivity = false;
                App.setDiskActivity(App.diskActivity, diskActivityIndicator);
            }
        }
    }

    public static void fireDiskActivityIndicatorChanged() {
        diskActivityIndicatorChanged = true;
    }

    public static String getLicense() {
        return license;
    }

    public static boolean loadFdsBIOS() {
        if (App.isFdsBiosLoaded()) {
            return true;
        }
        try {
            FilePath filePath = AppPrefs.getInstance().getFamicomDiskSystemPrefs().getBiosFile();
            if (filePath == null) {
                return false;
            }
            FileUtil.getInputStream(filePath, (in, length) -> {
                try {
                    App.loadFdsBIOS(in, length);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return App.isFdsBiosLoaded();
    }

    public static void loadFdsBIOS(InputStream inputStream, long fileLength) throws Throwable {
        if (fileLength != 8192L) {
            throw new MessageException("Invalid FDS BIOS file length.");
        }
        int[] bios = new int[8192];
        try (BufferedInputStream s = new BufferedInputStream(inputStream);){
            StreamUtil.readByteArray(s, bios);
            fdsBIOS = bios;
        }
    }

    public static boolean isEmulator() {
        return imageFrame != null;
    }

    public static boolean isFdsBiosLoaded() {
        return fdsBIOS != null;
    }

    public static int[] getFdsBIOS() {
        return fdsBIOS;
    }

    public static AsmDasmFrame getAsmDasmFrame() {
        return asmDasmFrame;
    }

    public static DebuggerFrame getDebuggerFrame() {
        return debuggerFrame;
    }

    public static RamSearchFrame getRamSearchFrame() {
        return ramSearchFrame;
    }

    public static RamWatchFrame getRamWatchFrame() {
        return ramWatchFrame;
    }

    public static CheatSearchFrame getCheatSearchFrame() {
        return cheatSearchFrame;
    }

    public static GlassesFrame getGlassesFrame() {
        return glassesFrame;
    }

    public static HexEditorFrame getHexEditorFrame() {
        return hexEditorFrame;
    }

    public static HistoryEditorFrame getHistoryEditorFrame() {
        return historyEditorFrame;
    }

    public static ImageFrame getImageFrame() {
        return imageFrame;
    }

    public static ProgramFrame getProgramFrame() {
        return programFrame;
    }

    public static ProgramServerFrame getProgramServerFrame() {
        return programServerFrame;
    }

    public static NetplayServerFrame getNetworkServerFrame() {
        return netplayServerFrame;
    }

    public static NetplayClientFrame getNetworkClientFrame() {
        return netplayClientFrame;
    }

    public static VolumeMixerFrame getVolumeMixerFrame() {
        return volumeMixerFrame;
    }

    public static SubMonitorFrame getSubMonitorFrame() {
        return subMonitorFrame;
    }

    public static WatchHistoryFrame getWatchHistoryFrame() {
        return watchHistoryFrame;
    }

    public static MachineRunner getMachineRunner() {
        return machineRunner;
    }

    public static Machine getMachine() {
        return machine;
    }

    public static Cart getCart() {
        CartFile cartFile = App.getCartFile();
        return cartFile != null ? cartFile.getCart() : null;
    }

    public static CartFile getCartFile() {
        return nesFile != null ? nesFile : unifFile;
    }

    public static UnifFile getUnifFile() {
        return unifFile;
    }

    public static NesFile getNesFile() {
        return nesFile;
    }

    public static FdsFile getFdsFile() {
        return fdsFile;
    }

    public static NsfFile getNsfFile() {
        return nsfFile;
    }

    public static IFile getFile() {
        if (nesFile != null) {
            return nesFile;
        }
        if (fdsFile != null) {
            return fdsFile;
        }
        if (unifFile != null) {
            return unifFile;
        }
        if (nsfFile != null) {
            return nsfFile;
        }
        return null;
    }

    public static boolean isFileLoaded() {
        return nesFile != null || fdsFile != null || unifFile != null || nsfFile != null;
    }

    public static String getEntryFileName() {
        return entryFileName;
    }

    public static ProgramServer getProgramServer() {
        return programServer;
    }

    public static NetplayServer getNetplayServer() {
        return netplayServer;
    }

    public static NetplayClient getNetplayClient() {
        return netplayClient;
    }

    public static Boolean showDipSwitchesDialog() {
        if (EventQueue.isDispatchThread()) {
            boolean ok = false;
            App.setNoStepPause(true);
            List<DipSwitch> dipSwitches = App.getDipSwitches();
            if (dipSwitches != null && !dipSwitches.isEmpty()) {
                DipSwitchesDialog dialog = new DipSwitchesDialog((Window)imageFrame, dipSwitches);
                dialog.setVisible(true);
                ok = dialog.isOK();
            }
            App.setNoStepPause(false);
            return ok;
        }
        GamePrefs.load(entryFileName);
        return GuiUtil.invokeAndWait(App::showDipSwitchesDialog);
    }

    public static boolean isVsSystem() {
        NesFile file = nesFile;
        return file != null && file.isVsSystem();
    }

    public static boolean isVsUniSystem() {
        NesFile file = nesFile;
        return file != null && file.isVsUniSystem();
    }

    public static boolean isVsDualSystem() {
        NesFile file = nesFile;
        return file != null && file.isVsDualSystem();
    }

    public static void startProgramServer() {
        if (EventQueue.isDispatchThread()) {
            new Thread(App::startProgramServer).start();
        } else {
            programServer.start();
        }
    }

    public static void stopProgramServer() {
        if (EventQueue.isDispatchThread()) {
            new Thread(App::stopProgramServer).start();
        } else {
            programServer.stop();
        }
    }

    public static void startNetplayServer() {
        if (EventQueue.isDispatchThread()) {
            new Thread(App::startNetplayServer).start();
        } else {
            netplayServer.start();
        }
    }

    public static void stopNetplayServer() {
        if (EventQueue.isDispatchThread()) {
            new Thread(App::stopNetplayServer).start();
        } else {
            netplayServer.stop();
        }
    }

    public static void startClient(char[] password) {
        if (EventQueue.isDispatchThread()) {
            new Thread(() -> App.startClient(password)).start();
        } else {
            netplayClient.start(password);
        }
    }

    public static void stopClient() {
        if (EventQueue.isDispatchThread()) {
            new Thread(App::stopClient).start();
        } else {
            netplayClient.stop();
        }
    }

    public static Mapper loadFile(DataInputStream in, long fileSize, String fileName) throws Throwable {
        return App.loadFile(in, fileSize, fileName, null);
    }

    public static Mapper loadFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName) throws Throwable {
        App.close();
        int fileType = FileUtil.getFileType(in);
        if (fileType == 0 && !StringUtil.isBlank(entryFileName)) {
            switch (FileUtil.getFileExtension(entryFileName)) {
                case "fds": {
                    fileType = 2;
                    break;
                }
                case "unf": 
                case "unif": {
                    fileType = 3;
                    break;
                }
                case "nsf": 
                case "nsfe": {
                    fileType = 4;
                    break;
                }
                default: {
                    fileType = 1;
                }
            }
        }
        Mapper mapper = null;
        switch (fileType) {
            case 2: {
                nesFile = null;
                fdsFile = new FdsFile(in, fileSize, entryFileName, archiveFileName, fdsBIOS);
                unifFile = null;
                nsfFile = null;
                mapper = new FdsMapper(fdsFile);
                break;
            }
            case 3: {
                fdsFile = null;
                nesFile = null;
                unifFile = new UnifFile(in, fileSize, entryFileName, archiveFileName);
                nsfFile = null;
                mapper = Mapper.create(unifFile);
                break;
            }
            case 4: {
                fdsFile = null;
                nesFile = null;
                unifFile = null;
                nsfFile = new NsfFile(in, fileSize, entryFileName, archiveFileName);
                mapper = new NsfMapper(nsfFile);
                break;
            }
            default: {
                fdsFile = null;
                nesFile = new NesFile(in, fileSize, entryFileName, archiveFileName);
                unifFile = null;
                nsfFile = null;
                mapper = Mapper.create(nesFile);
            }
        }
        if (mapper == null) {
            throw new MessageException("Mapper %s is not supported.", nesFile != null ? Integer.valueOf(nesFile.getMapperNumber()) : unifFile.getMapper());
        }
        CartFile cartFile = App.getCartFile();
        if (cartFile != null && cartFile.isVsSystem() && cartFile.getVsGame() == null) {
            throw new MessageException("This VS. System game is not recognized.");
        }
        if (StringUtil.isBlank(entryFileName)) {
            App.entryFileName = FileUtil.getFileName(archiveFileName);
            historyProjectName = FileUtil.getFileNameWithoutExtension(archiveFileName);
        } else {
            App.entryFileName = FileUtil.getFileName(entryFileName);
            historyProjectName = FileUtil.getFileNameWithoutExtension(entryFileName);
        }
        if (StringUtil.isBlank(historyProjectName)) {
            historyProjectName = "game";
        }
        historyProjectName = historyProjectName + ".history";
        imageFrame.updateContentPane(mapper, nsfFile);
        return mapper;
    }

    public static String createMachine(Mapper mapper, Machine ejectedMachine) {
        if (ejectedMachine != null && mapper.isVsDualSystem()) {
            throw new MessageException("Hot Swap to VS. DualSystem is not supported.");
        }
        GamePrefs.load(entryFileName);
        GameCheats.load(entryFileName);
        AppPrefs.getInstance().getInputs().autoConfigure(App.getCartFile());
        VsGame vsGame = nesFile != null ? nesFile.getVsGame() : null;
        machine = ejectedMachine == null ? new Machine(mapper, vsGame) : new Machine(mapper, ejectedMachine);
        machine.getPPU().setNoSpriteLimit(AppPrefs.getInstance().getView().isNoSpriteLimit());
        boolean paletteUpdated = vsGame != null ? PaletteUtil.setVsPPU(vsGame.getPPU()) : (nesFile != null && nesFile.isPlaychoice10() ? PaletteUtil.usePlayChoice10PPU() : PaletteUtil.setPalettePPU(PalettePPU._2C02));
        if (paletteUpdated) {
            imageFrame.createPaletteMenu();
        }
        imageFrame.setMachine(machine);
        mapper.setMachine(machine);
        if (vsGame != null) {
            mapper.setDipSwitchesValue(DipSwitch.evaluate(vsGame.getDipSwitches(), GamePrefs.getInstance().getDipSwitchesGamePrefs().getDipSwitchValues()));
            InputUtil.setVsGame(vsGame);
        } else {
            InputUtil.setVsGame(null);
        }
        mapper.loadNonVolatilePrgRam();
        PPU ppu = machine.getPPU();
        SetTVSystem.run(machine, mapper.getPreferredTVSystem());
        machine.getAPU().setAudioProcessor(systemAudioProcessor);
        ppu.setScreenRenderer(imageFrame.getImagePane());
        if (ejectedMachine == null) {
            machine.getCPU().init();
        }
        mapper.init();
        machineRunner = new MachineRunner(machine);
        App.setTrackHistory(AppPrefs.getInstance().getHistoryPrefs().isTrackHistory());
        if (App.isGyromite()) {
            new SetupROB(new GyromiteController()).run(machine);
        } else if (App.isStackUp()) {
            new SetupROB(new StackUpController()).run(machine);
        } else if (App.isVsDualSystem()) {
            App.createSubMonitorFrame();
        }
        App.updateFrames(machineRunner);
        InputUtil.pollControllers(machine);
        netplayServer.setMachineRunner(machineRunner);
        new Thread((Runnable)machineRunner, "Machine Runner Thread").start();
        StringBuilder sb = new StringBuilder();
        sb.append(App.getFile());
        sb.append(System.lineSeparator());
        sb.append(String.format("PRG ROM banks: %d%n", mapper.getPrgBankCount()));
        sb.append(String.format("PRG ROM bank size: %d bytes%n", mapper.getPrgBankSize()));
        sb.append(String.format("CHR ROM banks: %d%n", mapper.getChrBankCount()));
        sb.append(String.format("CHR ROM bank size: %d bytes%n", mapper.getChrBankSize()));
        return sb.toString();
    }

    public static void saveState(Window parent, File file, int slot) {
        App.saveState(parent, file, slot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveState(Window parent, File file, int slot, Runnable saveListener) {
        Machine m = machine;
        if (m != null) {
            App.setNoStepPause(true);
            try (ByteArrayOutputStream baos = StreamUtil.toByteArrayOutputStream(m);){
                new Thread(() -> {
                    FileUtil.mkdir(file.getParent());
                    try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                        StreamUtil.writeByteArrayOutputStream(out, baos);
                        out.close();
                        if (saveListener != null) {
                            EventQueue.invokeLater(saveListener);
                        }
                        App.showMessage(slot < 0 ? "SAVED" : String.format("SAVED (%d)", slot));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        GuiUtil.displayError(parent, "Failed to save game state.");
                    }
                }).start();
            }
            catch (Throwable t) {
                t.printStackTrace();
                GuiUtil.displayError(parent, "Failed to save game state.");
            }
            finally {
                App.setNoStepPause(false);
            }
        }
    }

    public static void loadState(Window parent, File file, int slot) {
        if (file == null || !file.exists()) {
            GuiUtil.displayError(parent, "Failed to load game state: File not found.");
            return;
        }
        new Thread(() -> {
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                MachineRunner m = new MachineRunner((Machine)StreamUtil.readObject(in));
                App.loadState(nesFile, fdsFile, unifFile, nsfFile, m);
                m.getMachine().getPPU().setNoSpriteLimit(AppPrefs.getInstance().getView().isNoSpriteLimit());
                InputUtil.setMachine(m.getMachine());
                netplayServer.postSaveState(m);
                HistoryEditorFrame historyEditor = historyEditorFrame;
                if (historyEditor != null) {
                    historyEditor.setMachineRunner(m);
                } else {
                    new Thread(m).start();
                }
                App.showMessage(slot < 0 ? "LOADED" : String.format("LOADED (%d)", slot));
            }
            catch (Throwable t) {
                GuiUtil.displayError(parent, "Failed to load game state.");
            }
        }).start();
    }

    public static void loadState(IFile file, MachineRunner runner) {
        NesFile nesFile = null;
        FdsFile fdsFile = null;
        UnifFile unifFile = null;
        NsfFile nsfFile = null;
        switch (file.getFileType()) {
            case 1: {
                nesFile = (NesFile)file;
                break;
            }
            case 2: {
                fdsFile = (FdsFile)file;
                break;
            }
            case 3: {
                unifFile = (UnifFile)file;
                break;
            }
            case 4: {
                nsfFile = (NsfFile)file;
            }
        }
        App.loadState(nesFile, fdsFile, unifFile, nsfFile, runner);
    }

    private static void loadState(NesFile nes, FdsFile fds, UnifFile unif, NsfFile nsf, MachineRunner r) {
        App.close(false, true);
        nesFile = nes;
        fdsFile = fds;
        unifFile = unif;
        nsfFile = nsf;
        machineRunner = r;
        if (machineRunner != null) {
            VsGame vsGame;
            machine = machineRunner.getMachine();
            Mapper mapper = machine.getMapper();
            mapper.restore(nesFile);
            mapper.restore(unifFile);
            mapper.restore(fdsFile);
            mapper.restore(nsfFile);
            imageFrame.setMachine(machine);
            App.updateFrames(machineRunner);
            machine.getAPU().setAudioProcessor(systemAudioProcessor);
            machine.getPPU().setScreenRenderer(imageFrame.getImagePane());
            VsGame vsGame2 = vsGame = nesFile != null ? nesFile.getVsGame() : null;
            if (vsGame != null) {
                SubMonitorFrame subMonitor;
                InputUtil.setVsGame(vsGame);
                if (vsGame.isDualSystemGame() && (subMonitor = subMonitorFrame) != null) {
                    ((MainCPU)machine.getCPU()).getSubPPU().setScreenRenderer(subMonitor.getImagePane());
                }
            } else {
                InputUtil.setVsGame(null);
            }
        }
        App.setTrackHistory(AppPrefs.getInstance().getHistoryPrefs().isTrackHistory());
    }

    public static void handleDipSwitchChange(List<DipSwitch> dipSwitches) {
        MachineRunner r = machineRunner;
        if (r != null) {
            InputUtil.addOtherInput(new ChangeDipSwitches(DipSwitch.evaluate(dipSwitches, GamePrefs.getInstance().getDipSwitchesGamePrefs().getDipSwitchValues())));
        }
    }

    public static List<DipSwitch> getDipSwitches() {
        NesFile file = App.getNesFile();
        if (file == null || !file.isVsSystem()) {
            return null;
        }
        VsGame vsGame = file.getVsGame();
        return vsGame == null ? DipSwitch.createDefaultDipSwitches() : vsGame.getDipSwitches();
    }

    public static void handleFrameRendered(MachineRunner machineRunner) {
        DebuggerFrame debugger;
        RamWatchFrame ramWatch;
        RamSearchFrame ramSearch;
        CheatSearchFrame cheatSearch;
        HexEditorFrame hexEditor;
        GlassesFrame glasses = glassesFrame;
        if (glasses != null) {
            glasses.update(machineRunner);
        }
        if ((hexEditor = hexEditorFrame) != null) {
            hexEditor.update();
        }
        if ((cheatSearch = cheatSearchFrame) != null) {
            cheatSearch.update();
        }
        if ((ramSearch = ramSearchFrame) != null) {
            ramSearch.update();
        }
        if ((ramWatch = ramWatchFrame) != null) {
            ramWatch.update();
        }
        if ((debugger = debuggerFrame) != null) {
            debugger.update();
        }
    }

    public static void scanlineRendered(int scanline) {
        LocalAPI api;
        SpriteSaverFrame spriteSaver;
        MapMakerFrame mapMaker;
        NametablesFrame nametables;
        PatternTablesFrame patternTables;
        OamDataFrame oamData = oamDataFrame;
        if (oamData != null) {
            oamData.update(scanline);
        }
        if ((patternTables = patternTablesFrame) != null) {
            patternTables.update(scanline);
        }
        if ((nametables = nametablesFrame) != null) {
            nametables.update(scanline);
        }
        if ((mapMaker = mapMakerFrame) != null) {
            mapMaker.update(scanline);
        }
        if ((spriteSaver = spriteSaverFrame) != null) {
            spriteSaver.update(scanline);
        }
        if ((api = localAPI) != null) {
            api.scanlineRendered(scanline);
        }
    }

    public static void firePauseChanged(boolean paused) {
        DebuggerFrame debugger = debuggerFrame;
        if (debugger != null) {
            debugger.onPausedChanged(paused);
        }
    }

    public static void fireStepPausedChanged(boolean stepPause) {
        EventQueue.invokeLater(() -> {
            RamSearchFrame ramSearch;
            CheatSearchFrame cheatSearch;
            ImageFrame image = imageFrame;
            if (image != null) {
                image.onStepPausedChanged(stepPause);
            }
            if ((cheatSearch = cheatSearchFrame) != null) {
                cheatSearch.onStepPausedChanged(stepPause);
            }
            if ((ramSearch = ramSearchFrame) != null) {
                ramSearch.onStepPausedChanged(stepPause);
            }
        });
    }

    public static void createHistoryEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            App.destroyWatchHistoryFrame();
            if (historyEditorFrame == null) {
                App.setAppMode(AppMode.HistoryEditor);
                historyEditorFrame = new HistoryEditorFrame(machineRunner != null && machineRunner.isRunning() ? machineRunner : null);
                historyEditorFrame.setVisible(true);
            } else {
                GuiUtil.toFront(historyEditorFrame);
            }
        } else {
            EventQueue.invokeLater(App::createHistoryEditorFrame);
        }
    }

    public static void destroyHistoryEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (historyEditorFrame != null) {
                App.setAppMode(AppMode.Default);
                historyEditorFrame.destroy();
                historyEditorFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyHistoryEditorFrame);
        }
    }

    public static void createProgramServerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (programServerFrame == null) {
                programServerFrame = new ProgramServerFrame();
                programServerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(programServerFrame);
            }
        } else {
            EventQueue.invokeLater(App::createProgramServerFrame);
        }
    }

    public static void destroyProgramServerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (programServerFrame != null) {
                programServerFrame.destroy();
                programServerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyProgramServerFrame);
        }
    }

    public static void createNetplayServerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (netplayServerFrame == null) {
                App.setAppMode(AppMode.NetplayServer);
                App.destroyBarcodeBattlerFrame();
                App.destroyGlassesFrame();
                netplayServerFrame = new NetplayServerFrame();
                netplayServerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(netplayServerFrame);
            }
        } else {
            EventQueue.invokeLater(App::createNetplayServerFrame);
        }
    }

    public static void destroyNetplayServerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (netplayServerFrame != null) {
                App.setAppMode(AppMode.Default);
                netplayServerFrame.destroy();
                netplayServerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyNetplayServerFrame);
        }
    }

    public static void createNetplayClientFrame() {
        if (EventQueue.isDispatchThread()) {
            if (netplayClientFrame == null) {
                App.setAppMode(AppMode.NetplayClient);
                netplayClientFrame = new NetplayClientFrame();
                netplayClientFrame.setVisible(true);
            } else {
                GuiUtil.toFront(netplayClientFrame);
            }
        } else {
            EventQueue.invokeLater(App::createNetplayClientFrame);
        }
    }

    public static void destroyNetplayClientFrame() {
        if (EventQueue.isDispatchThread()) {
            if (netplayClientFrame != null) {
                App.setAppMode(AppMode.Default);
                netplayClientFrame.destroy();
                netplayClientFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyNetplayClientFrame);
        }
    }

    public static void createAsmDasmFrame() {
        if (EventQueue.isDispatchThread()) {
            if (asmDasmFrame == null) {
                asmDasmFrame = new AsmDasmFrame();
                asmDasmFrame.setVisible(true);
            } else {
                GuiUtil.toFront(asmDasmFrame);
            }
        } else {
            EventQueue.invokeLater(App::createAsmDasmFrame);
        }
    }

    public static void destroyAsmDasmFrame() {
        if (EventQueue.isDispatchThread()) {
            if (asmDasmFrame != null) {
                asmDasmFrame.destroy();
                asmDasmFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyAsmDasmFrame);
        }
    }

    public static void createDebuggerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (debuggerFrame == null) {
                debuggerFrame = new DebuggerFrame(machineRunner != null && machineRunner.isRunning() ? machineRunner : null);
                debuggerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(debuggerFrame);
            }
        } else {
            EventQueue.invokeLater(App::createDebuggerFrame);
        }
    }

    public static void destroyDebuggerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (debuggerFrame != null) {
                debuggerFrame.destroy();
                debuggerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyDebuggerFrame);
        }
    }

    public static void createRamWatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (ramWatchFrame == null) {
                ramWatchFrame = new RamWatchFrame(App.getRunningMachine());
                ramWatchFrame.setVisible(true);
            } else {
                GuiUtil.toFront(ramWatchFrame);
            }
        } else {
            EventQueue.invokeLater(App::createRamWatchFrame);
        }
    }

    public static void destroyRamWatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (ramWatchFrame != null) {
                ramWatchFrame.destroy();
                ramWatchFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyRamWatchFrame);
        }
    }

    public static void createRamSearchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (ramSearchFrame == null) {
                ramSearchFrame = new RamSearchFrame(App.getRunningMachine());
                ramSearchFrame.setVisible(true);
            } else {
                GuiUtil.toFront(ramSearchFrame);
            }
        } else {
            EventQueue.invokeLater(App::createRamSearchFrame);
        }
    }

    public static void destroyRamSearchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (ramSearchFrame != null) {
                ramSearchFrame.destroy();
                ramSearchFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyRamSearchFrame);
        }
    }

    public static void createSpriteSaverFrame() {
        if (EventQueue.isDispatchThread()) {
            if (spriteSaverFrame == null) {
                spriteSaverFrame = new SpriteSaverFrame(App.getRunningMachine());
                spriteSaverFrame.setVisible(true);
            } else {
                GuiUtil.toFront(spriteSaverFrame);
            }
        } else {
            EventQueue.invokeLater(App::createSpriteSaverFrame);
        }
    }

    public static void destroySpriteSaverFrame() {
        if (EventQueue.isDispatchThread()) {
            if (spriteSaverFrame != null) {
                spriteSaverFrame.destroy();
                spriteSaverFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroySpriteSaverFrame);
        }
    }

    public static void createMapMakerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (mapMakerFrame == null) {
                Machine m = machine;
                mapMakerFrame = new MapMakerFrame(App.getRunningMachine());
                mapMakerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(mapMakerFrame);
            }
        } else {
            EventQueue.invokeLater(App::createMapMakerFrame);
        }
    }

    public static void destroyMapMakerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (mapMakerFrame != null) {
                mapMakerFrame.destroy();
                mapMakerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyMapMakerFrame);
        }
    }

    public static void createNametablesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (nametablesFrame == null) {
                nametablesFrame = new NametablesFrame(machineRunner);
                nametablesFrame.setVisible(true);
            } else {
                GuiUtil.toFront(nametablesFrame);
            }
        } else {
            EventQueue.invokeLater(App::createNametablesFrame);
        }
    }

    public static void destroyNametablesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (nametablesFrame != null) {
                nametablesFrame.destroy();
                nametablesFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyNametablesFrame);
        }
    }

    public static void createOamDataFrame() {
        if (EventQueue.isDispatchThread()) {
            if (oamDataFrame == null) {
                oamDataFrame = new OamDataFrame(machineRunner);
                oamDataFrame.setVisible(true);
            } else {
                GuiUtil.toFront(oamDataFrame);
            }
        } else {
            EventQueue.invokeLater(App::createOamDataFrame);
        }
    }

    public static void destroyOamDataFrame() {
        if (EventQueue.isDispatchThread()) {
            if (oamDataFrame != null) {
                oamDataFrame.destroy();
                oamDataFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyOamDataFrame);
        }
    }

    public static void createPatternTablesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (patternTablesFrame == null) {
                patternTablesFrame = new PatternTablesFrame(machineRunner);
                patternTablesFrame.setVisible(true);
            } else {
                GuiUtil.toFront(patternTablesFrame);
            }
        } else {
            EventQueue.invokeLater(App::createPatternTablesFrame);
        }
    }

    public static void destroyPatternTablesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (patternTablesFrame != null) {
                patternTablesFrame.destroy();
                patternTablesFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyPatternTablesFrame);
        }
    }

    public static void createBackgroundEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (backgroundEditorFrame == null) {
                Machine m = App.getRunningMachine();
                if (m != null) {
                    backgroundEditorFrame = new BackgroundEditorFrame(m);
                    backgroundEditorFrame.setVisible(true);
                }
            } else {
                GuiUtil.toFront(backgroundEditorFrame);
            }
        } else {
            EventQueue.invokeLater(App::createBackgroundEditorFrame);
        }
    }

    public static void destroyBackgroundEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (backgroundEditorFrame != null) {
                backgroundEditorFrame.destroy();
                backgroundEditorFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyBackgroundEditorFrame);
        }
    }

    public static void createCheatSearchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (cheatSearchFrame == null) {
                cheatSearchFrame = new CheatSearchFrame(App.getRunningMachine());
                cheatSearchFrame.setVisible(true);
            } else {
                GuiUtil.toFront(cheatSearchFrame);
            }
        } else {
            EventQueue.invokeLater(App::createCheatSearchFrame);
        }
    }

    public static void destroyCheatSearchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (cheatSearchFrame != null) {
                cheatSearchFrame.destroy();
                cheatSearchFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyCheatSearchFrame);
        }
    }

    public static void createHexEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (hexEditorFrame == null) {
                hexEditorFrame = new HexEditorFrame();
                hexEditorFrame.setMachine(App.getRunningMachine());
                hexEditorFrame.setVisible(true);
            } else {
                GuiUtil.toFront(hexEditorFrame);
            }
        } else {
            EventQueue.invokeLater(App::createHexEditorFrame);
        }
    }

    public static void destroyHexEditorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (hexEditorFrame != null) {
                hexEditorFrame.destroy();
                hexEditorFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyHexEditorFrame);
        }
    }

    public static void updateRobFrame(RobController rob) {
        if (rob != null) {
            App.updateRobFrame(rob.getState());
        }
    }

    public static void updateRobFrame(RobState state) {
        RobFrame frame = robFrame;
        if (frame != null) {
            frame.render(state);
        }
    }

    public static void createRobFrame(int game) {
        if (EventQueue.isDispatchThread()) {
            if (game == 0) {
                App.destroyRobFrame();
            } else if (robFrame == null) {
                robFrame = new RobFrame(game);
                GuiUtil.forwardKeyEvents(robFrame, imageFrame);
                robFrame.setVisible(true);
                GuiUtil.toFront(imageFrame);
            } else {
                robFrame.setGame(game);
                GuiUtil.toFront(robFrame);
                GuiUtil.toFront(imageFrame);
            }
        } else {
            EventQueue.invokeLater(() -> App.createRobFrame(game));
        }
    }

    public static void destroyRobFrame() {
        if (EventQueue.isDispatchThread()) {
            InputUtil.setRob(null);
            if (robFrame != null) {
                robFrame.destroy();
                robFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyRobFrame);
        }
    }

    public static void updateGlassesFrame(int[] screen) {
        GlassesFrame frame = glassesFrame;
        if (frame != null) {
            frame.update(screen);
        }
    }

    public static void createGlassesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (glassesFrame == null) {
                glassesFrame = new GlassesFrame();
                GuiUtil.forwardKeyEvents(glassesFrame, imageFrame);
                glassesFrame.setVisible(true);
            } else {
                GuiUtil.toFront(glassesFrame);
            }
            GuiUtil.toFront(imageFrame);
        } else {
            EventQueue.invokeLater(App::createGlassesFrame);
        }
    }

    public static void destroyGlassesFrame() {
        if (EventQueue.isDispatchThread()) {
            if (glassesFrame != null) {
                glassesFrame.destroy();
                glassesFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyGlassesFrame);
        }
    }

    public static void createBarcodeBattlerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (barcodeBattlerFrame == null) {
                barcodeBattlerFrame = new BarcodeBattlerFrame();
                barcodeBattlerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(barcodeBattlerFrame);
            }
            GuiUtil.toFront(imageFrame);
        } else {
            EventQueue.invokeLater(App::createBarcodeBattlerFrame);
        }
    }

    public static void destroyBarcodeBattlerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (barcodeBattlerFrame != null) {
                barcodeBattlerFrame.destroy();
                barcodeBattlerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyBarcodeBattlerFrame);
        }
    }

    public static void createApplyIpsPatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (applyIpsPatchFrame == null) {
                applyIpsPatchFrame = new PatchFrame(true);
                applyIpsPatchFrame.setVisible(true);
            } else {
                GuiUtil.toFront(applyIpsPatchFrame);
            }
        } else {
            EventQueue.invokeLater(App::createApplyIpsPatchFrame);
        }
    }

    public static void destroyApplyIpsPatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (applyIpsPatchFrame != null) {
                applyIpsPatchFrame.destroy();
                applyIpsPatchFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyApplyIpsPatchFrame);
        }
    }

    public static void createCreateIpsPatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (createIpsPatchFrame == null) {
                createIpsPatchFrame = new PatchFrame(false);
                createIpsPatchFrame.setVisible(true);
            } else {
                GuiUtil.toFront(createIpsPatchFrame);
            }
        } else {
            EventQueue.invokeLater(App::createCreateIpsPatchFrame);
        }
    }

    public static void destroyCreateIpsPatchFrame() {
        if (EventQueue.isDispatchThread()) {
            if (createIpsPatchFrame != null) {
                createIpsPatchFrame.destroy();
                createIpsPatchFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyCreateIpsPatchFrame);
        }
    }

    public static void createWatchHistoryFrame() {
        if (EventQueue.isDispatchThread()) {
            App.destroyHistoryEditorFrame();
            if (watchHistoryFrame == null) {
                App.setAppMode(AppMode.WatchHistory);
                watchHistoryFrame = new WatchHistoryFrame();
                watchHistoryFrame.setVisible(true);
            } else {
                GuiUtil.toFront(watchHistoryFrame);
            }
        } else {
            EventQueue.invokeLater(App::createWatchHistoryFrame);
        }
    }

    public static void destroyWatchHistoryFrame() {
        if (EventQueue.isDispatchThread()) {
            if (watchHistoryFrame != null) {
                App.setAppMode(AppMode.Default);
                watchHistoryFrame.destroy();
                watchHistoryFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyWatchHistoryFrame);
        }
    }

    public static void createVolumeMixerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (volumeMixerFrame == null) {
                volumeMixerFrame = new VolumeMixerFrame();
                volumeMixerFrame.setVisible(true);
            } else {
                GuiUtil.toFront(volumeMixerFrame);
            }
        } else {
            EventQueue.invokeLater(App::createVolumeMixerFrame);
        }
    }

    public static void destroyVolumeMixerFrame() {
        if (EventQueue.isDispatchThread()) {
            if (volumeMixerFrame != null) {
                volumeMixerFrame.destroy();
                volumeMixerFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyVolumeMixerFrame);
        }
    }

    public static void createSubMonitorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (subMonitorFrame == null) {
                subMonitorFrame = new SubMonitorFrame();
                GuiUtil.forwardKeyEvents(subMonitorFrame, imageFrame);
                subMonitorFrame.setVisible(true);
                EventQueue.invokeLater(() -> GuiUtil.toFront(imageFrame));
            } else {
                GuiUtil.toFront(subMonitorFrame);
            }
            subMonitorFrame.init();
        } else {
            EventQueue.invokeLater(App::createSubMonitorFrame);
        }
    }

    public static void destroySubMonitorFrame() {
        if (EventQueue.isDispatchThread()) {
            if (subMonitorFrame != null) {
                subMonitorFrame.destroy();
                subMonitorFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroySubMonitorFrame);
        }
    }

    public static void createProgramFrame() {
        if (EventQueue.isDispatchThread()) {
            if (programFrame == null) {
                programFrame = new ProgramFrame();
                programFrame.setVisible(true);
            } else {
                GuiUtil.toFront(programFrame);
            }
        } else {
            EventQueue.invokeLater(App::createProgramFrame);
        }
    }

    public static void destroyProgramFrame() {
        if (EventQueue.isDispatchThread()) {
            if (programFrame != null) {
                programFrame.destroy();
                programFrame = null;
            }
        } else {
            EventQueue.invokeLater(App::destroyProgramFrame);
        }
    }

    public static void runSubMonitorFrame(SubMonitorFrameFunction function) {
        SubMonitorFrame frame = subMonitorFrame;
        if (frame != null) {
            function.f(frame);
        }
    }

    public static void runVsDualImagePane(ImagePane imagePane, ImagePaneFunction function) {
        SubMonitorFrame frame = subMonitorFrame;
        if (frame == null) {
            return;
        }
        ImagePane pane = frame.getImagePane();
        if (pane == null || pane == imagePane) {
            return;
        }
        function.f(pane);
    }

    public static void setTrackHistory(boolean trackHistory) {
        App.clearRewindTime();
        App.clearHighSpeed();
        MachineRunner r = machineRunner;
        if (r != null) {
            if (trackHistory) {
                Movie movie = r.getMovie();
                if (movie == null) {
                    movie = new Movie(App.isVsDualSystem());
                    r.setMovie(movie);
                    r.getMapper().updateButtons(0);
                    SystemAudioProcessor.setMovie(movie);
                }
                imageFrame.setHistoryTracking(true);
            } else {
                r.setMovie(null);
                r.getMapper().updateButtons(0);
                SystemAudioProcessor.setMovie(null);
                imageFrame.setHistoryTracking(false);
            }
        } else {
            imageFrame.setHistoryTracking(false);
        }
    }

    public static void clearHighSpeed() {
        highSpeedValue = 0;
    }

    public static void requestHighSpeed(int portIndex) {
        highSpeedValue = BitUtil.toggleBit(highSpeedValue, portIndex);
    }

    public static void requestHighSpeed(int portIndex, boolean highSpeed) {
        highSpeedValue = BitUtil.setBit(highSpeedValue, portIndex, highSpeed);
    }

    public static void updateHighSpeed() {
        if (netplayClient.isRunning()) {
            netplayClient.post(21, highSpeedValue);
        } else {
            highSpeedValue = netplayServer.isRunning() ? netplayServer.mergeHighSpeed(highSpeedValue) : (highSpeedValue &= 0xF);
            App.setHighSpeed(highSpeedValue != 0);
        }
    }

    public static void clearRewindTime() {
        rewindTimeValue = 0;
    }

    public static void requestRewindTime(int portIndex) {
        rewindTimeValue = BitUtil.toggleBit(rewindTimeValue, portIndex);
    }

    public static void requestRewindTime(int portIndex, boolean rewindTime) {
        rewindTimeValue = BitUtil.setBit(rewindTimeValue, portIndex, rewindTime);
    }

    public static void updateRewindTime() {
        if (netplayClient.isRunning()) {
            netplayClient.post(14, rewindTimeValue);
        } else {
            rewindTimeValue = netplayServer.isRunning() ? netplayServer.mergeRewindTime(rewindTimeValue) : (rewindTimeValue &= 0x1F);
            boolean rewindTime = rewindTimeValue != 0;
            MachineRunner r = machineRunner;
            if (r != null) {
                if (rewindTime) {
                    Movie movie;
                    if (r.isForwardTime() && (movie = r.getMovie()) != null && !movie.movieBlocks.isEmpty()) {
                        App.updateFrames(null);
                        imageFrame.setTimeRewinding(true);
                        r.setForwardTime(false);
                    }
                } else if (!r.isForwardTime()) {
                    imageFrame.setTimeRewinding(false);
                    App.updateFrames(machineRunner);
                    r.setForwardTime(true);
                }
            }
        }
    }

    public static void setNoStepPause(boolean noStepPause) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.setNoStepPause(noStepPause);
        }
        if (noStepPause) {
            SystemAudioProcessor.flush();
        }
    }

    public static void setStepPause(boolean stepPause) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.setStepPause(stepPause);
        }
        if (stepPause) {
            SystemAudioProcessor.flush();
        }
    }

    public static void step(PauseStepType pauseStepType) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.step(pauseStepType);
        }
    }

    public static void stepToAddress(int address) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.stepToAddress(address);
        }
    }

    public static void stepToScanline(int scanline) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.stepToScanline(scanline);
        }
    }

    public static void stepToDot(int scanlineCycle) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.stepToDot(scanlineCycle);
        }
    }

    public static void stepToOpcode(int opcode) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.stepToOpcode(opcode);
        }
    }

    public static void stepToInstructions(int instructions) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.stepToInstructions(instructions);
        }
    }

    public static void setBreakpoints(List<Breakpoint> breakpoints) {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.setBreakpoints(breakpoints);
        }
    }

    public static void setHighSpeed(boolean highSpeed) {
        if (TimeUtil.isHighSpeed() != highSpeed) {
            TimeUtil.setHighSpeed(highSpeed);
            APU.setNormalSpeed(TimeUtil.getSpeed() == 100 && !highSpeed);
        }
    }

    public static void setSpeed(int percent) {
        if (percent < 1) {
            percent = 0;
        }
        TimeUtil.setSpeed(percent);
        APU.setNormalSpeed(percent == 100 && !TimeUtil.isHighSpeed());
    }

    public static int getSpeed() {
        return TimeUtil.getSpeed();
    }

    public static void showMessage(String message) {
        imageFrame.getImagePane().showMessage(message);
        if (netplayServer.isRunning()) {
            netplayServer.post(20, message);
        }
    }

    public static void reset() {
        if (machineRunner != null) {
            InputUtil.addOtherInput(new Reset());
        }
    }

    public static String eraseBatterySave() {
        if (machineRunner != null) {
            GamePrefs.getInstance().eraseNonVolatileRam();
            GamePrefs.save();
        }
        return App.powerCycle(false, false);
    }

    public static String powerCycle() {
        return App.powerCycle(false, true);
    }

    public static String powerCycle(boolean closeFrames, boolean saveNonVolatileData) {
        String entryFile = entryFileName;
        FdsFile fds = fdsFile;
        NesFile nes = nesFile;
        UnifFile unif = unifFile;
        NsfFile nsf = nsfFile;
        App.close(closeFrames, saveNonVolatileData);
        entryFileName = entryFile;
        fdsFile = fds;
        nesFile = nes;
        unifFile = unif;
        nsfFile = nsf;
        Mapper mapper = null;
        if (fds != null) {
            mapper = new FdsMapper(fds);
        } else if (nes != null) {
            mapper = Mapper.create(nes);
        } else if (unif != null) {
            mapper = Mapper.create(unif);
        } else if (nsf != null) {
            mapper = new NsfMapper(nsfFile);
        }
        return App.createMachine(mapper, null);
    }

    public static void startTraceLogger() {
        App.disposeTraceLogger();
        MachineRunner r = machineRunner;
        if (r != null) {
            traceLogger = new TraceLogger();
            r.setTraceLogger(traceLogger);
        }
    }

    public static boolean isTraceLoggerRunning() {
        return traceLogger != null;
    }

    public static void flushTraceLogger() {
        TraceLogger logger = traceLogger;
        if (logger != null) {
            logger.flush();
        }
    }

    public static void disposeTraceLogger() {
        TraceLogger logger = traceLogger;
        if (logger != null) {
            traceLogger = null;
            MachineRunner r = machineRunner;
            if (r != null) {
                r.setTraceLogger(null);
            }
            logger.dispose();
        }
    }

    public static void setMachineRunner(MachineRunner machineRunner) {
        App.machineRunner = machineRunner;
        if (machineRunner == null) {
            machine = null;
            App.setDiskActivity(false);
            diskActivityIndicatorChanged = true;
            fds = false;
        } else {
            machine = machineRunner.getMachine();
            fds = machine.getMapper().isFdsMapper();
        }
        App.setTrackHistory(AppPrefs.getInstance().getHistoryPrefs().isTrackHistory());
    }

    public static void updateFrames(MachineRunner machineRunner) {
        LocalAPI api;
        DebuggerFrame debugger;
        RamWatchFrame ramWatch;
        RamSearchFrame ramSearch;
        SpriteSaverFrame spriteSaver;
        MapMakerFrame maperMaker;
        NametablesFrame nametables;
        BackgroundEditorFrame backgroundEditor;
        PatternTablesFrame patternTables;
        OamDataFrame oamData;
        CheatSearchFrame cheatSearch;
        HexEditorFrame hexEditor;
        Machine m = machineRunner != null ? machineRunner.getMachine() : null;
        ImageFrame image = imageFrame;
        if (image != null) {
            image.setMachine(m);
        }
        if ((hexEditor = hexEditorFrame) != null) {
            hexEditor.setMachine(m);
        }
        if ((cheatSearch = cheatSearchFrame) != null) {
            cheatSearch.setMachine(m);
        }
        if ((oamData = oamDataFrame) != null) {
            oamData.setMachineRunner(machineRunner);
        }
        if ((patternTables = patternTablesFrame) != null) {
            patternTables.setMachineRunner(machineRunner);
        }
        if ((backgroundEditor = backgroundEditorFrame) != null) {
            backgroundEditor.setMachine(m);
        }
        if ((nametables = nametablesFrame) != null) {
            nametables.setMachineRunner(machineRunner);
        }
        if ((maperMaker = mapMakerFrame) != null) {
            maperMaker.setMachine(m);
        }
        if ((spriteSaver = spriteSaverFrame) != null) {
            spriteSaver.setMachine(m);
        }
        if ((ramSearch = ramSearchFrame) != null) {
            ramSearch.setMachine(m);
        }
        if ((ramWatch = ramWatchFrame) != null) {
            ramWatch.setMachine(m);
        }
        if ((debugger = debuggerFrame) != null) {
            debugger.setMachineRunner(machineRunner);
        }
        if ((api = localAPI) != null) {
            api.setMachineRunner(machineRunner);
        }
    }

    public static void setLocalAPI(LocalAPI localAPI) {
        App.localAPI = localAPI;
        if (localAPI != null) {
            localAPI.setMachineRunner(machineRunner);
        }
    }

    public static LocalAPI getLocalAPI() {
        return localAPI;
    }

    public static void close() {
        App.close(true, true);
    }

    public static void close(boolean closeFrames, boolean saveNonVolatileData) {
        App.setStepPause(false);
        App.clearRewindTime();
        App.clearHighSpeed();
        Machine m = machine;
        if (m != null) {
            m.getMapper().close(saveNonVolatileData);
        }
        if (closeFrames) {
            App.destroyBarcodeBattlerFrame();
            App.destroyGlassesFrame();
            App.destroyRobFrame();
            App.destroyWatchHistoryFrame();
            App.destroySubMonitorFrame();
        }
        imageFrame.updateContentPane(null, null);
        imageFrame.setHistoryTracking(false);
        GuiUtil.invokeAndWait(() -> {});
        App.dispose();
        netplayServer.setMachineRunner(null);
        App.setSpeed(100);
        imageFrame.getImagePane().setCursorType(CursorType.Default);
    }

    public static void dispose() {
        MachineRunner r = machineRunner;
        if (r != null) {
            r.dispose();
        }
        imageFrame.getImagePane().clearScreen();
        App.updateFrames(null);
        AppPrefs.getInstance().getInputs().autoConfigure();
        AppPrefs.save();
        InputUtil.setVsGame(null);
        GamePrefs.dispose();
        App.setMachineRunner(null);
        SystemAudioProcessor.flush();
        nesFile = null;
        fdsFile = null;
        unifFile = null;
        nsfFile = null;
    }

    public static void destroyFrames() {
        App.destroyApplyIpsPatchFrame();
        App.destroyAsmDasmFrame();
        App.destroyBackgroundEditorFrame();
        App.destroyBarcodeBattlerFrame();
        App.destroyCheatSearchFrame();
        App.destroyCreateIpsPatchFrame();
        App.destroyDebuggerFrame();
        App.destroyGlassesFrame();
        App.destroyHexEditorFrame();
        App.destroyHistoryEditorFrame();
        App.destroyMapMakerFrame();
        App.destroyNametablesFrame();
        App.destroyNetplayClientFrame();
        App.destroyNetplayServerFrame();
        App.destroyOamDataFrame();
        App.destroyPatternTablesFrame();
        App.destroyProgramFrame();
        App.destroyProgramServerFrame();
        App.destroyRamSearchFrame();
        App.destroyRamWatchFrame();
        App.destroyRobFrame();
        App.destroySpriteSaverFrame();
        App.destroySubMonitorFrame();
        App.destroyVolumeMixerFrame();
        App.destroyWatchHistoryFrame();
    }

    public static SystemAudioProcessor getSystemAudioProcessor() {
        return systemAudioProcessor;
    }

    private App() {
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        appMode = AppMode.Default;
        programServer = new ProgramServer();
        netplayServer = new NetplayServer();
        netplayClient = new NetplayClient();
        diskActivityIndicator = DiskActivityIndicator.NUM_LOCK;
        diskActivityIndicatorChanged = true;
        lastPlayFrameHasFocus = true;
        lastApplicationHasFocus = true;
    }
}

