module Tetriminos

import NintacoTetrisAI.PLAYFIELD_WIDTH
import NintacoTetrisAI.PLAYFIELD_HEIGHT
import NintacoTetrisAI.Orientation

const NONE = -1
const T = 1
const J = 2
const Z = 3
const O = 4
const S = 5
const L = 6
const I = 7

const PATTERNS = [
  [ [ [ -1,  0 ], [  0,  0 ], [  1,  0 ], [  0,  1 ], ],    # Td (spawn)
    [ [  0, -1 ], [ -1,  0 ], [  0,  0 ], [  0,  1 ], ],    # Tl    
    [ [ -1,  0 ], [  0,  0 ], [  1,  0 ], [  0, -1 ], ],    # Tu
    [ [  0, -1 ], [  0,  0 ], [  1,  0 ], [  0,  1 ], ], ], # Tr   

  [ [ [ -1,  0 ], [  0,  0 ], [  1,  0 ], [  1,  1 ], ],    # Jd (spawn)
    [ [  0, -1 ], [  0,  0 ], [ -1,  1 ], [  0,  1 ], ],    # Jl
    [ [ -1, -1 ], [ -1,  0 ], [  0,  0 ], [  1,  0 ], ],    # Ju
    [ [  0, -1 ], [  1, -1 ], [  0,  0 ], [  0,  1 ], ], ], # Jr   

  [ [ [ -1,  0 ], [  0,  0 ], [  0,  1 ], [  1,  1 ], ],    # Zh (spawn) 
    [ [  1, -1 ], [  0,  0 ], [  1,  0 ], [  0,  1 ], ], ], # Zv   

  [ [ [ -1,  0 ], [  0,  0 ], [ -1,  1 ], [  0,  1 ], ], ], # O  (spawn)   

  [ [ [  0,  0 ], [  1,  0 ], [ -1,  1 ], [  0,  1 ], ],    # Sh (spawn)
    [ [  0, -1 ], [  0,  0 ], [  1,  0 ], [  1,  1 ], ], ], # Sv   

  [ [ [ -1,  0 ], [  0,  0 ], [  1,  0 ], [ -1,  1 ], ],    # Ld (spawn)
    [ [ -1, -1 ], [  0, -1 ], [  0,  0 ], [  0,  1 ], ],    # Ll
    [ [  1, -1 ], [ -1,  0 ], [  0,  0 ], [  1,  0 ], ],    # Lu
    [ [  0, -1 ], [  0,  0 ], [  0,  1 ], [  1,  1 ], ], ], # Lr      

  [ [ [ -2,  0 ], [ -1,  0 ], [  0,  0 ], [  1,  0 ], ],    # Ih (spawn)    
    [ [  0, -2 ], [  0, -1 ], [  0,  0 ], [  0,  1 ], ], ], # Iv      
]

const ORIENTATION_IDS = Int[ 0x02, 0x03, 0x00, 0x01, 0x07, 0x04, 0x05, 0x06, 
    0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0E, 0x0F, 0x10, 0x0D, 0x12, 0x11 ]

const ORIENTATIONS = Array{Array{Orientation,1},1}(undef, length(PATTERNS))

let
  idIndex = 1
  for i = 1:length(PATTERNS)
    ORIENTATIONS[i] = Array{Orientation,1}(undef, 0)
    for j = 1:length(PATTERNS[i])    
      tetrimino = Orientation()
      push!(ORIENTATIONS[i], tetrimino)
      minX = typemax(Int)
      maxX = typemin(Int)
      maxY = typemin(Int)
      for k = 1:4
        p = PATTERNS[i][j][k]
        tetrimino.squares[k].x = p[1]
        tetrimino.squares[k].y = p[2]
        minX = min(minX, p[1])
        maxX = max(maxX, p[1])
        maxY = max(maxY, p[2])          
      end
      tetrimino.minX = 1 - minX
      tetrimino.maxX = PLAYFIELD_WIDTH - maxX
      tetrimino.maxY = PLAYFIELD_HEIGHT - maxY
      tetrimino.orientationID = ORIENTATION_IDS[idIndex]
      idIndex += 1
    end
  end  
end  
    
end