mutable struct Searcher
  states::Array{State}
  queue::Queue
  searchListener::Function
  positionValidator::Union{Function,Nothing}
  
  function Searcher(searchListener, positionValidator)
    self = new()
    self.states = Array{State}(undef, 4, PLAYFIELD_WIDTH, PLAYFIELD_HEIGHT)
    for y = 1:PLAYFIELD_HEIGHT
      for x = 1:PLAYFIELD_WIDTH
        for rotation = 1:4
          self.states[rotation, x, y] = State(x, y, rotation)
        end
      end
    end
    self.queue = Queue()
    self.searchListener = searchListener
    self.positionValidator = positionValidator
    return self
  end
end
  
function lockTetrimino(self, playfield, tetriminoType, id, state)
  squares = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation].squares
  for i = 1:4
    square = squares[i]
    y = state.y + square.y
    if y >= 1
      playfield[y][state.x + square.x] = tetriminoType
      playfield[y][PLAYFIELD_WIDTH + 1] += 1
    end
  end
  self.searchListener(playfield, tetriminoType, id, state)
  for i = 1:4
    square = squares[i]
    y = state.y + square.y
    if y >= 1
      playfield[y][state.x + square.x] = Tetriminos.NONE
      playfield[y][PLAYFIELD_WIDTH + 1] -= 1
    end
  end
end
  
# returns true if the position is valid even if the node is not enqueued
function addChild(self, playfield, tetriminoType, mark, state, x, y, rotation)

  orientation = Tetriminos.ORIENTATIONS[tetriminoType][rotation]
  if x < orientation.minX || x > orientation.maxX || y > orientation.maxY
    return false
  end

  childNode = self.states[rotation, x, y]
  if childNode.visited == mark
    return true
  end

  squares = orientation.squares
  for i = 1:4
    square = squares[i]
    playfieldY = y + square.y
    if (playfieldY >= 1 
        && playfield[playfieldY][x + square.x] != Tetriminos.NONE)
      return false
    end
  end
  
  if (self.positionValidator != nothing 
      && !self.positionValidator(playfield, tetriminoType, x, y, rotation))
    return true
  end

  childNode.visited = mark
  childNode.predecessor = state
      
  enqueue(self.queue, childNode)
  return true
end  
  
function search(self, playfield, tetriminoType, id)

  maxRotation = length(Tetriminos.ORIENTATIONS[tetriminoType])

  mark = global globalMark += 1

  if !addChild(self, playfield, tetriminoType, mark, nothing, 6, 1, 1)
    return false
  end

  while isNotEmpty(self.queue)
    state = dequeue(self.queue)

    if maxRotation != 1
      addChild(self, playfield, tetriminoType, mark, state, state.x, state.y, 
          state.rotation == 1 ? maxRotation : state.rotation - 1)
      if maxRotation != 2
        addChild(self, playfield, tetriminoType, mark, state, state.x, state.y, 
            state.rotation == maxRotation ? 1 : state.rotation + 1)
      end
    end

    addChild(self, playfield, tetriminoType, mark, state, 
        state.x - 1, state.y, state.rotation)
    addChild(self, playfield, tetriminoType, mark, state, 
        state.x + 1, state.y, state.rotation)

    if (!addChild(self, playfield, tetriminoType, mark, state,
        state.x, state.y + 1, state.rotation))
      lockTetrimino(self, playfield, tetriminoType, id, state)
    end
  end

  return true
end