mutable struct Queue
  head::Union{State,Nothing}
  tail::Union{State,Nothing}

  function Queue()
    return new(nothing, nothing)
  end  
end

function enqueue(queue, state)
  if queue.head == nothing
    queue.head = state
    queue.tail = state        
  else
    queue.tail.next = state
    queue.tail = state        
  end
  state.next = nothing
end

function dequeue(queue)
  state = queue.head
  if queue.head != nothing
    if queue.head == queue.tail
      queue.head = nothing
      queue.tail = nothing
    else
      queue.head = queue.head.next
    end
  end
  return state
end

function isEmpty(queue) 
  return queue.head == nothing
end

function isNotEmpty(queue)
  return queue.head != nothing
end