mutable struct PlayfieldUtil
  spareRows::Array{Array{Int,1},1}
  columnDepths::Array{Int,1}
  spareIndex::Int
  
  function PlayfieldUtil()
    self = new()
    self.spareRows = Array{Array{Int,1},1}(undef, 8 * TETRIMINOS_SEARCHED)
    for y = 1 : length(self.spareRows)
      self.spareRows[y] = Array{Int,1}(undef, PLAYFIELD_WIDTH + 1)
      for x = 1 : PLAYFIELD_WIDTH
        self.spareRows[y][x] = Tetriminos.NONE
      end
      self.spareRows[y][PLAYFIELD_WIDTH + 1] = 0
    end
    self.columnDepths = zeros(Int, PLAYFIELD_WIDTH)
    self.spareIndex = 1
    return self
  end
end

function createPlayfield(self)
  playfield = Array{Array{Int,1},1}(undef, PLAYFIELD_HEIGHT)
  for y = 1 : PLAYFIELD_HEIGHT
    playfield[y] = Array{Int,1}(undef, PLAYFIELD_WIDTH + 1)
    for x = 1 : PLAYFIELD_WIDTH
      playfield[y][x] = Tetriminos.NONE
    end
    playfield[y][PLAYFIELD_WIDTH + 1] = 0
  end
  return playfield
end
  
function lockTetrimino(self, playfield, tetriminoType, state)
  
  squares = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation].squares
  for i = 1:4
    square = squares[i]
    y = state.y + square.y
    if y >= 1
      playfield[y][state.x + square.x] = tetriminoType
      playfield[y][PLAYFIELD_WIDTH + 1] += 1
    end
  end
  
  startRow = state.y - 2
  endRow = state.y + 1
  
  if startRow < 2
    startRow = 2
  end
  if endRow > PLAYFIELD_HEIGHT
    endRow = PLAYFIELD_HEIGHT
  end
  
  for y = startRow:endRow
    if playfield[y][PLAYFIELD_WIDTH + 1] == PLAYFIELD_WIDTH
      clearedRow = playfield[y]
      for i = y:-1:2
        playfield[i] = playfield[i - 1]
      end        
      for x = 1:PLAYFIELD_WIDTH
        clearedRow[x] = Tetriminos.NONE          
      end
      clearedRow[PLAYFIELD_WIDTH + 1] = 0
      playfield[1] = clearedRow
    end
  end
end  
  
function evaluatePlayfield(self, playfield, e)
  
  for x = 1:PLAYFIELD_WIDTH
    self.columnDepths[x] = PLAYFIELD_HEIGHT
    for y = 1:PLAYFIELD_HEIGHT
      if playfield[y][x] != Tetriminos.NONE
        self.columnDepths[x] = y
        break
      end
    end
  end
  
  e.wells = 0
  for x = 1:PLAYFIELD_WIDTH
    minY = 1
    if x == 1
      minY = self.columnDepths[2]
    elseif x == PLAYFIELD_WIDTH
      minY = self.columnDepths[PLAYFIELD_WIDTH - 1]
    else
      minY = max(self.columnDepths[x - 1], self.columnDepths[x + 1])
    end
    for y = self.columnDepths[x]:-1:minY
      if ((x == 1 || playfield[y][x - 1] != Tetriminos.NONE)
          && (x == PLAYFIELD_WIDTH || playfield[y][x + 1] != Tetriminos.NONE))
        e.wells += 1
      end
    end
  end
  
  e.holes = 0
  e.columnTransitions = 0
  for x = 1:PLAYFIELD_WIDTH
    solid = true
    for y = self.columnDepths[x] + 1 : PLAYFIELD_HEIGHT
      if playfield[y][x] == Tetriminos.NONE
        if playfield[y - 1][x] != Tetriminos.NONE
          e.holes += 1
        end
        if solid
          solid = false
          e.columnTransitions += 1
        end
      elseif !solid
        solid = true
        e.columnTransitions += 1
      end
    end
  end
  
  e.rowTransitions = 0
  for y = 1:PLAYFIELD_HEIGHT
    solidFound = false
    solid = true
    transitions = 0
    for x = 1 : PLAYFIELD_WIDTH + 1
      if x == PLAYFIELD_WIDTH + 1
        if !solid
          transitions += 1
        end
      else
        if playfield[y][x] == Tetriminos.NONE
          if solid
            solid = false
            transitions += 1
          end
        else
          solidFound = true
          if !solid
            solid = true
            transitions += 1                           
          end
        end
      end
    end
    if solidFound
      e.rowTransitions += transitions
    end
  end  
end
  
function clearRows(self, playfield, tetriminoY)
  
  rows = 0
  startRow = tetriminoY - 2
  endRow = tetriminoY + 1
  
  if startRow < 2
    startRow = 2
  end
  if endRow > PLAYFIELD_HEIGHT
    endRow = PLAYFIELD_HEIGHT
  end
  
  for y = startRow:endRow
    if playfield[y][PLAYFIELD_WIDTH + 1] == PLAYFIELD_WIDTH
      rows += 1
      clearRow(self, playfield, y)
    end
  end
  
  return rows
end
  
function clearRow(self, playfield, y)
          
  clearedRow = playfield[y]
  clearedRow[PLAYFIELD_WIDTH + 1] = y
  for i = y:-1:2
    playfield[i] = playfield[i - 1]
  end
  playfield[1] = self.spareRows[self.spareIndex]
  playfield[1][PLAYFIELD_WIDTH + 1] = 0
  
  self.spareRows[self.spareIndex] = clearedRow
  self.spareIndex += 1
end
  
function restoreRow(self, playfield)
  self.spareIndex -= 1
  restoredRow = self.spareRows[self.spareIndex]
  y = restoredRow[PLAYFIELD_WIDTH + 1]
  
  self.spareRows[self.spareIndex] = playfield[1]
  
  for i = 1 : y - 1
    playfield[i] = playfield[i + 1]
  end
  restoredRow[PLAYFIELD_WIDTH + 1] = PLAYFIELD_WIDTH
  playfield[y] = restoredRow
end
  
function restoreRows(self, playfield, rows)
  for i = 1:rows
    restoreRow(self, playfield)
  end    
end