mutable struct AI
  searchers::Array{Searcher,1}
  tetriminoIndices::Array{Int,1}
  playfieldUtil::PlayfieldUtil
  e::PlayfieldEvaluation
  totalRows::Int
  totalDropHeight::Int
  bestFitness::Float64  
  bestResult::Union{State,Nothing}
  result0::Union{State,Nothing}
  searchListener::Function
  
  function AI(positionValidator)
    self = new()
    self.searchers = Array{Searcher,1}(undef, TETRIMINOS_SEARCHED)
    for i = 1:TETRIMINOS_SEARCHED
      self.searchers[i] = Searcher((playfield, tetriminoType, id, state) 
          -> searchListener(self, playfield, tetriminoType, id, state), 
              positionValidator)
    end
    self.playfieldUtil = PlayfieldUtil()
    self.e = PlayfieldEvaluation()
    self.totalRows = 0
    self.totalDropHeight = 0
    self.bestFitness = 0.0
    self.bestResult = nothing
    self.result0 = nothing
    return self
  end
  
  function AI()
    return AI(nothing)
  end
end

function searchListener(self, playfield, tetriminoType, id, state)    
  if id == 0
    self.result0 = state
  end

  orientation = Tetriminos.ORIENTATIONS[tetriminoType][state.rotation]
  rows = clearRows(self.playfieldUtil, playfield, state.y)
  originalTotalRows = self.totalRows
  originalTotalDropHeight = self.totalDropHeight
  self.totalRows += rows
  self.totalDropHeight += orientation.maxY - state.y

  nextID = id + 1

  if nextID == length(self.tetriminoIndices)
    evaluatePlayfield(self.playfieldUtil, playfield, self.e)
    fitness = computeFitness(self)    
    if fitness < self.bestFitness
      self.bestFitness = fitness
      self.bestResult = self.result0
    end
  else
    search(self.searchers[1 + nextID], playfield, 
        self.tetriminoIndices[1 + nextID], nextID)
  end

  self.totalDropHeight = originalTotalDropHeight
  self.totalRows = originalTotalRows
  restoreRows(self.playfieldUtil, playfield, rows)
end

function computeFitness(self)
  return (WEIGHTS[1] * self.totalRows
       + WEIGHTS[2] * self.totalDropHeight
       + WEIGHTS[3] * self.e.wells
       + WEIGHTS[4] * self.e.holes                 
       + WEIGHTS[5] * self.e.columnTransitions
       + WEIGHTS[6] * self.e.rowTransitions)        
end
  
function search(self, playfield, tetriminoIndices)
  self.tetriminoIndices = tetriminoIndices
  self.bestResult = nothing
  self.bestFitness = typemax(Float64)

  search(self.searchers[1], playfield, tetriminoIndices[1], 0)

  return self.bestResult
end
  
function buildStatesList(self, state)
  s = state
  count = 0
  while s != nothing
    count += 1
    s = s.predecessor
  end
  states = Array{State, 1}(undef, count)
  while state != nothing    
    states[count] = state
    count -= 1
    state = state.predecessor
  end
  return states
end