module NintacoHelloWorld

using Nintaco

const STRING = "Hello, World!"
  
const SPRITE_ID = 123
const SPRITE_SIZE = 32

mutable struct HelloWorld
  api::RemoteAPI
  spriteX::Int
  spriteY::Int
  spriteVx::Int
  spriteVy::Int  
  strWidth::Int
  strX::Int
  strY::Int
  
  HelloWorld() = new(ApiSource.getAPI(), 0, 8, 1, 1, 0, 0, 0)
end

function launch(self)
  addFrameListener(self.api, () -> renderFinished(self))
  addStatusListener(self.api, (message) -> statusChanged(self, message))
  addActivateListener(self.api, () -> apiEnabled(self))
  addDeactivateListener(self.api, () -> apiDisabled(self))
  addStopListener(self.api, () -> dispose(self))  
  Nintaco.run(self.api)  
end

function apiEnabled(self)
  println("API enabled")
  
  sprite = Array{Int,1}(undef, SPRITE_SIZE * SPRITE_SIZE)
  for y = 0 : SPRITE_SIZE - 1
    Y = y - SPRITE_SIZE ÷ 2 + 0.5
    for x = 0 : SPRITE_SIZE - 1
      X = x - SPRITE_SIZE ÷ 2 + 0.5
      sprite[SPRITE_SIZE * y + x + 1] = (X * X + Y * Y 
          <= SPRITE_SIZE * SPRITE_SIZE ÷ 4) ? Colors.ORANGE : -1 
    end
  end
  createSprite(self.api, SPRITE_ID, SPRITE_SIZE, SPRITE_SIZE, sprite)
  
  self.strWidth = getStringWidth(self.api, STRING, false)
  self.strX = (256 - self.strWidth) ÷ 2
  self.strY = (240 - 8) ÷ 2
end
  
function apiDisabled(self)
  println("API disabled")
end

function dispose(self)
  println("API stopped")
end

function statusChanged(self, message)  
  println("Status message: $message")
end
  
function renderFinished(self)
  drawSprite(self.api, SPRITE_ID, self.spriteX, self.spriteY)
  if self.spriteX + SPRITE_SIZE == 255
    self.spriteVx = -1
  elseif self.spriteX == 0
    self.spriteVx = 1
  end
  if self.spriteY + SPRITE_SIZE == 231
    self.spriteVy = -1
  elseif self.spriteY == 8
    self.spriteVy = 1
  end
  self.spriteX += self.spriteVx
  self.spriteY += self.spriteVy
      
  setColor(self.api, Colors.DARK_BLUE)
  fillRect(self.api, self.strX - 1, self.strY - 1, self.strWidth + 2, 9)
  setColor(self.api, Colors.BLUE)
  drawRect(self.api, self.strX - 2, self.strY - 2, self.strWidth + 3, 10)
  setColor(self.api, Colors.WHITE)
  drawString(self.api, STRING, self.strX, self.strY, false)
end

function main()
  ApiSource.initRemoteAPI("localhost", 9999)
  launch(HelloWorld())
end

end