const ARRAY_LENGTH = 1024

function writeByte(stream, x)
  write(stream, convert(UInt8, x))
end  

function readByte(stream)::Int
  return read(stream, UInt8)
end
  
function writeInt(stream, value)
  writeByte(stream, (value >>> 24) & 0xFF)
  writeByte(stream, (value >>> 16) & 0xFF)
  writeByte(stream, (value >>> 8) & 0xFF)
  writeByte(stream, value & 0xFF)
end  

function readInt(stream)
  b1 = readByte(stream)
  b2 = readByte(stream)
  b3 = readByte(stream)
  b4 = readByte(stream)
  return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4
end
  
function writeIntArray(stream, array)
  len = length(array)
  writeInt(stream, len)
  for i = 1:len
    writeInt(stream, array[i])
  end
end
  
function readIntArray(stream, array)
  len = readInt(stream)
  if len < 0 || len > length(array)
    close(stream)
    error("Invalid array length: $len")
  end
  for i = 1:len
    array[i] = readInt(stream)
  end
  return len
end
  
function writeBoolean(stream, value)
  write(stream, value ? 0x01 : 0x00)
end
  
function readBoolean(stream)
  return read(stream, UInt8) != 0x00
end
  
function writeChar(stream, value)
  writeByte(stream, value)
end
  
function readChar(stream)::Char
  readByte(stream)
end
  
function writeCharArray(stream, array)
  len = length(array)
  writeInt(stream, len)
  for i = 1:len
    writeByte(stream, array[i])
  end
end

function readCharArray(stream, array)
  len = readInt(stream)
  if len < 0 || len > length(array)
    close(stream)
    error("Invalid array length: $len")
  end
  for i = 1:len
    array[i] = readChar(stream)
  end
  return len
end
  
function writeString(stream, value)
  len = length(value)
  writeInt(stream, len)
  for i = 1:len
    writeByte(stream, value[i])
  end
end
  
function readString(stream)
  len = readInt(stream)
  if len < 0 || len > ARRAY_LENGTH
    close(stream)
    error("Invalid array length: $len")
  end
  cs = Array{UInt8, 1}(undef, len)
  for i = 1:len
    cs[i] = read(stream, UInt8)
  end
  return String(cs)
end
  
function writeStringArray(stream, array)
  len = length(array)
  writeInt(len)
  for i = 1:len
    writeString(stream, array[i])
  end
end
  
function readStringArray(stream, array)
  len = readInt(stream)
  if len < 0 || len > length(array)
    close(stream)
    error("Invalid array length: $len")
  end
  for i = 1:len
    array[i] = readString(stream)
  end
  return len
end
  
function readDynamicStringArray(stream)
  len = readInt(stream)
  if len < 0 || len > ARRAY_LENGTH
    close(stream)
    error("Invalid array length: $len")
  end
  array = Array{String, 1}(undef, len)
  for i = 1:len
    array[i] = readString(stream)
  end
  return array
end