import nintaco.api.*;

public class HelloWorld {

  private static final String STRING = "Hello, World!";
  
  private static final int SPRITE_ID = 123;
  private static final int SPRITE_SIZE = 32;
  
  private final API api = ApiSource.getAPI();
  
  private int spriteX = 0;
  private int spriteY = 8;
  private int spriteVx = 1;
  private int spriteVy = 1;
  
  private int strWidth;
  private int strX;
  private int strY;
  
  public void launch() {
    api.addFrameListener(this::renderFinished);
    api.addStatusListener(this::statusChanged);
    api.addActivateListener(this::apiEnabled);
    api.addDeactivateListener(this::apiDisabled);
    api.addStopListener(this::dispose);
    api.run();
  }
  
  private void apiEnabled() {
    System.out.println("API enabled");
    
    final int[] sprite = new int[SPRITE_SIZE * SPRITE_SIZE];
    for(int y = 0; y < SPRITE_SIZE; y++) {
      final double Y = y - SPRITE_SIZE / 2 + 0.5;
      for(int x = 0; x < SPRITE_SIZE; x++) {
        final double X = x - SPRITE_SIZE / 2 + 0.5;
        sprite[SPRITE_SIZE * y + x] = X * X + Y * Y 
            <= SPRITE_SIZE * SPRITE_SIZE / 4 ? Colors.ORANGE : -1; 
      }
    }
    api.createSprite(SPRITE_ID, SPRITE_SIZE, SPRITE_SIZE, sprite);
    
    strWidth = api.getStringWidth(STRING, false);
    strX = (256 - strWidth) / 2;
    strY = (240 - 8) / 2;
  }
  
  private void apiDisabled() {
    System.out.println("API disabled");
  }
  
  private void dispose() {
    System.out.println("API stopped");
  }
  
  private void statusChanged(final String message) {
    System.out.format("Status message: %s%n", message);
  }
  
  private void renderFinished() {
    api.drawSprite(SPRITE_ID, spriteX, spriteY);
    if (spriteX + SPRITE_SIZE == 255) {
      spriteVx = -1;
    } else if (spriteX == 0) {
      spriteVx = 1;
    }
    if (spriteY + SPRITE_SIZE == 231) {
      spriteVy = -1;
    } else if (spriteY == 8) {
      spriteVy = 1;
    }
    spriteX += spriteVx;
    spriteY += spriteVy;
        
    api.setColor(Colors.DARK_BLUE);
    api.fillRect(strX - 1, strY - 1, strWidth + 2, 9);
    api.setColor(Colors.BLUE);
    api.drawRect(strX - 2, strY - 2, strWidth + 3, 10);
    api.setColor(Colors.WHITE);
    api.drawString(STRING, strX, strY, false);
  }
  
  public static void main(final String... args) {
    ApiSource.initRemoteAPI("localhost", 9999);
    new HelloWorld().launch();
  }
}