﻿using System;
using System.Collections.Generic;
using System.Linq;
using Nintaco;

namespace HelloWorld {

  public class HelloWorld {

    private static readonly String STRING = "Hello, World!";

    private static readonly int SPRITE_ID = 123;
    private static readonly int SPRITE_SIZE = 32;

    private readonly RemoteAPI api = ApiSource.API;

    private int spriteX = 0;
    private int spriteY = 8;
    private int spriteVx = 1;
    private int spriteVy = 1;

    private int strWidth;
    private int strX;
    private int strY;

    public void launch() {
      api.addFrameListener(renderFinished);
      api.addStatusListener(statusChanged);
      api.addActivateListener(apiEnabled);
      api.addDeactivateListener(apiDisabled);
      api.addStopListener(dispose);
      api.run();
    }

    private void apiEnabled() {
      Console.WriteLine("API enabled");

      int[] sprite = new int[SPRITE_SIZE * SPRITE_SIZE];
      for(int y = 0; y < SPRITE_SIZE; y++) {
        double Y = y - SPRITE_SIZE / 2 + 0.5;
        for(int x = 0; x < SPRITE_SIZE; x++) {
          double X = x - SPRITE_SIZE / 2 + 0.5;
          sprite[SPRITE_SIZE * y + x] = X * X + Y * Y 
              <= SPRITE_SIZE * SPRITE_SIZE / 4 ? Colors.ORANGE : -1;
        }
      }
      api.createSprite(SPRITE_ID, SPRITE_SIZE, SPRITE_SIZE, sprite);

      strWidth = api.getStringWidth(STRING, false);
      strX = (256 - strWidth) / 2;
      strY = (240 - 8) / 2;
    }

    private void apiDisabled() {
      Console.WriteLine("API disabled");
    }

    private void dispose() {
      Console.WriteLine("API stopped");
    }

    private void statusChanged(String message) {
      Console.WriteLine("Status message: {0}", message);
    }

    private void renderFinished() {
      api.drawSprite(SPRITE_ID, spriteX, spriteY);
      if(spriteX + SPRITE_SIZE == 255) {
        spriteVx = -1;
      } else if(spriteX == 0) {
        spriteVx = 1;
      }
      if(spriteY + SPRITE_SIZE == 231) {
        spriteVy = -1;
      } else if(spriteY == 8) {
        spriteVy = 1;
      }
      spriteX += spriteVx;
      spriteY += spriteVy;

      api.setColor(Colors.DARK_BLUE);
      api.fillRect(strX - 1, strY - 1, strWidth + 2, 9);
      api.setColor(Colors.BLUE);
      api.drawRect(strX - 2, strY - 2, strWidth + 3, 10);
      api.setColor(Colors.WHITE);
      api.drawString(STRING, strX, strY, false);
    }

    public static void Main(string[] args) {
      ApiSource.initRemoteAPI("localhost", 9999);
      new HelloWorld().launch();
    }
  }
}
