#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#include "nintaco.h"

#define STRING "Hello, World!"

#define SPRITE_ID 123
#define SPRITE_SIZE 32

NintacoAPI* api;

int spriteX = 0;
int spriteY = 8;
int spriteVx = 1;
int spriteVy = 1;

int strWidth;
int strX;
int strY;

void apiEnabled(NintacoAPI* api) {
  int x;
  int y;
  
  puts("API enabled");

  int sprite[SPRITE_SIZE * SPRITE_SIZE];
  for(y = 0; y < SPRITE_SIZE; y++) {
    double Y = y - SPRITE_SIZE / 2 + 0.5;
    for(x = 0; x < SPRITE_SIZE; x++) {
      double X = x - SPRITE_SIZE / 2 + 0.5;
      sprite[SPRITE_SIZE * y + x] = X * X + Y * Y 
          <= SPRITE_SIZE * SPRITE_SIZE / 4 ? ORANGE : -1; 
    }
  }
  createSprite(api, SPRITE_ID, SPRITE_SIZE, SPRITE_SIZE, sprite);

  strWidth = getStringWidth(api, STRING, false);
  strX = (256 - strWidth) / 2;
  strY = (240 - 8) / 2;
}

void apiDisabled(NintacoAPI* api) {
  puts("API disabled");
}

void dispose(NintacoAPI* api) {
  puts("API stopped");
}

void statusChanged(NintacoAPI* api, char* message) {
  printf("Status message: %s\n", message);
}

void renderFinished(NintacoAPI* api) {
  drawSprite(api, SPRITE_ID, spriteX, spriteY);
  if (spriteX + SPRITE_SIZE == 255) {
    spriteVx = -1;
  } else if (spriteX == 0) {
    spriteVx = 1;
  }
  if (spriteY + SPRITE_SIZE == 231) {
    spriteVy = -1;
  } else if (spriteY == 8) {
    spriteVy = 1;
  }
  spriteX += spriteVx;
  spriteY += spriteVy;
  
  setColor(api, DARK_BLUE);
  fillRect(api, strX - 1, strY - 1, strWidth + 2, 9);
  setColor(api, BLUE);
  drawRect(api, strX - 2, strY - 2, strWidth + 3, 10);
  setColor(api, WHITE);
  drawString(api, STRING, strX, strY, false);
}

int main(int argc, char** argv) {
  api = newNintacoAPI("localhost", 9999);
  addFrameListener(api, &renderFinished);
  addStatusListener(api, &statusChanged);
  addActivateListener(api, &apiEnabled);
  addDeactivateListener(api, &apiDisabled);
  addStopListener(api, &dispose);
  run(api);  
  return EXIT_SUCCESS;
}