/*
 * Decompiled with CFR 0.152.
 */
import nintaco.api.API;
import nintaco.api.ApiSource;

public class HelloWorld {
    private static final String STRING = "Hello, World!";
    private static final int SPRITE_ID = 123;
    private static final int SPRITE_SIZE = 32;
    private final API api = ApiSource.getAPI();
    private int spriteX = 0;
    private int spriteY = 8;
    private int spriteVx = 1;
    private int spriteVy = 1;
    private int strWidth;
    private int strX;
    private int strY;

    public void launch() {
        this.api.addFrameListener(this::renderFinished);
        this.api.addStatusListener(this::statusChanged);
        this.api.addActivateListener(this::apiEnabled);
        this.api.addDeactivateListener(this::apiDisabled);
        this.api.addStopListener(this::dispose);
        this.api.run();
    }

    private void apiEnabled() {
        System.out.println("API enabled");
        int[] sprite = new int[1024];
        for (int y = 0; y < 32; ++y) {
            double Y = (double)(y - 16) + 0.5;
            for (int x = 0; x < 32; ++x) {
                double X = (double)(x - 16) + 0.5;
                sprite[32 * y + x] = X * X + Y * Y <= 256.0 ? 22 : -1;
            }
        }
        this.api.createSprite(123, 32, 32, sprite);
        this.strWidth = this.api.getStringWidth(STRING, false);
        this.strX = (256 - this.strWidth) / 2;
        this.strY = 116;
    }

    private void apiDisabled() {
        System.out.println("API disabled");
    }

    private void dispose() {
        System.out.println("API stopped");
    }

    private void statusChanged(String message) {
        System.out.format("Status message: %s%n", message);
    }

    private void renderFinished() {
        this.api.drawSprite(123, this.spriteX, this.spriteY);
        if (this.spriteX + 32 == 255) {
            this.spriteVx = -1;
        } else if (this.spriteX == 0) {
            this.spriteVx = 1;
        }
        if (this.spriteY + 32 == 231) {
            this.spriteVy = -1;
        } else if (this.spriteY == 8) {
            this.spriteVy = 1;
        }
        this.spriteX += this.spriteVx;
        this.spriteY += this.spriteVy;
        this.api.setColor(1);
        this.api.fillRect(this.strX - 1, this.strY - 1, this.strWidth + 2, 9);
        this.api.setColor(17);
        this.api.drawRect(this.strX - 2, this.strY - 2, this.strWidth + 3, 10);
        this.api.setColor(32);
        this.api.drawString(STRING, this.strX, this.strY, false);
    }

    public static void main(String ... args) {
        ApiSource.initRemoteAPI((String)"localhost", (int)9999);
        new HelloWorld().launch();
    }
}

